#!/bin/bash
# XXX superseded {{coor title dms|45|23|54|N|11|52|33|E|type:landmark}}
# {{coord|12|34|56|N|45|33|21|W|display=title}}
# {{coord|10.2|-20.3|type:landmark_region}}
# [[rellink]]
# [[rellink|Title Text]]
# [link Title]

# tags: public, private, secret, allowalllarge

umask 0

shopt -s extglob

# simple escape
http_escape () {
	out="$@"
	#out="${out//&amp;#/&#}"
	#out="${out//&/&amp;}"
	out=`echo "$out" | sed -e 's/&amp;#/\&#/g' -e 's/&\([^#]\)/\&amp;\1/g'`
	out="${out//</&lt;}"
	out="${out//>/&gt;}"
	out="${out//\"/&quot;}"
	# latin1 kludge ...
	#if [ "x${out/*\*/backslash}" = "xbackslash" ]; then
		#echo "$out" | sed -e 's/\\\([0-3][0-7][0-7]\)/\&0x\1;/g'
		echo "$out" | perl -pe '
			s/\\([0-3][0-7][0-7])/"&#".oct($1).";"/ge; 
			s#(^|[^\[])(https?://\S*)#$1<a href=\"$2\">$2</a>#g; 
			s#\{\{coor ([^\|]*) dms\|(\d+)\|(\d+)\|(\d+)\|(.)\|(\d+)\|(\d+)\|(\d+)\|(.)\|type:([^}]*)}}#Geohack: $1 <a href=\"https://toolserver.org/~magnus/geo/geohack.php?pagename=$1&params=${2}_${3}_${4}_${5}_${6}_${7}_${8}_${9}_type:${10}\">${2}o${3}'\''${4}&quot;${5} ${6}o${7}'\''${8}&quot;${9}</a>#msg;
			s#\{\{coord\|(\d+)\|(\d+)\|(\d+)\|(.)\|(\d+)\|(\d+)\|(\d+)\|(.)\|([^}]*)}}#Geohack: <a href=\"https://toolserver.org/~magnus/geo/geohack.php?params=${1}_${2}_${3}_${4}_${5}_${6}_${7}_${8}\">${1}o${2}'\''${3}&quot;${4} ${5}o${6}'\''${7}&quot;${8}</a>#msg;
			s#\{\{coord\|([0-9.-]+)\|([0-9.-]+)\|([^\|}]*)}}#Geohack: <a href=\"https://toolserver.org/~magnus/geo/geohack.php?params=${1}_N_${2}_E_$3\">${1}/${2}</a>#msg;
			s#\[\[([^\] ]*)\|(.+)\]\]#<a href=\"${1}\">${2}</a>#msg;
			s#\[\[([^\] ]*)\s*(.*)\]\]#<a href=\"${1}\">$1${2}</a>#msg;
			s#\[([^\] ]*)\s+([^\]]+)\]#<a href=\"${1}\">${2}</a>#msg;
			s#\[(http[^\] ]*)\]#<a href=\"${1}\">${1}</a>#msg;
			'
	#else
	#	echo "$out"
	#fi
	#out="${out//\\\\241/&161;}"
	#out="${out//\\\\340/&aacute;}" # ???
	#out="${out//\\\\341/&aacute;}"
	#out="${out//\\\\350/&egrave;}"
	#out="${out//\\\\351/&eacute;}"
	#out="${out//\\\\352/&eacute;}"
	#out="${out//\\\\361/&ntilda;}"
	#out="${out//\\\\363/&oacute;}"
	#out="${out//\\\\342/&acirconflex;}"
	
	out=
}


################################
# config variables
################################

# publishing
BASEURL="/~aoe"
BASEDIR="/home/aoe/public_html"
IMAGEDIR="images"
# top of images hierarchy
IMAGEURL="$BASEURL/$IMAGEDIR"
# needs images.css
CSSURL="$BASEURL/css"
CGIURL="$BASEURL/cgi-bin"
IMAGETITLE="aoe: images "
METAEDITOR="$0"
METAAUTHOR="Alexander Oelzant-Faderler (aoe) <alexander@oelzant.priv.at>"
# sizes (in pixels) for thumbs/small images
#SMALLPIX=19200 # 160x120
#MEDPIX=307200 # 640x480
SMALLPIX=49152 # 256x192
MEDPIX=480000 # 800x600
# always regenerate thumbs/small images? slow
ALWAYS_REGEN=0
# images with exif tags like this are public. see also -p option
PUBLIC="public"
ALWAYSPUBLICFILE=.public
ALLOWALLLARGEFILE=.allowalllarge
# images with exif tags like this are non-public, they only appear
# in the non-public folder (together with the ones not in the public ...)
PRIVATE="private|nonpublic|secret"
ROTATECGI="$CGIURL/rotate.cgi"
HTBASE=".htbase"
INCLUDEHEADER=".header.html"
# include parent/nav bars
INCLUDEVIRTUALDIRS=1
# allow all to view large images
ALLOWALLLARGE=0

DO_HTML=1

INDEXPRIVATE=index_private.html
# difference between public and private
INDEXNONPUBLIC=index_nonpublic.html
INDEXPUBLIC=index.html
HTACCESS=.htaccess
ALLOWFROMALL="Satisfy Any
Allow From All"
DENYFROMALL="Deny From All"
#COPYRIGHT="<table class=\"copyright\"><tr><td>
#unless stated otherwise all images (c)<br/>
#sofern nicht anders angegeben, liegt das Urheberrecht aller Bilder bei
#</td><td>"`http_escape "$METAAUTHOR"`"</td></tr></table>
#"
COPYRIGHT="<p class=\"copyright\"> (c) "`http_escape "$METAAUTHOR"`"<br/>
Be nice or else I'll replace you with a very small
<a href=\"/~aoe/mystuff/exifperm\">
shell script</a></p>"

NOPUBLICFILES="<p>No public files in this directory, feel free to contact me for authentication data</p>"

JHEAD=`which jhead`
if [ "x$JHEAD" = "x" -o ! -x "$JHEAD" ]; then 
	JHEAD=""
fi
	

WD=`pwd | xargs basename | sed -e 's/_/ /g'`

HTHEAD="Order Deny,Allow
Deny From all
AuthType Basic
# htpassw
AuthName "bilder"
AuthUserFile $BASEDIR/.htimages
AuthGroupFile $BASEDIR/.htgroup

require group users
allow from 62.116.99.136/29
allow from 131.130.2.239
allow from 62.178.208.184
allow from 80.109.64.67
allow from 217.196.64.204
allow from 78.142.175.66

satisfy any
<files index.html>
$ALLOWFROMALL
</files>
<files \"\">
$ALLOWFROMALL
</files>
<files subdirnav.html>
$ALLOWFROMALL
</files>
<files subdirnav_private.html>
$ALLOWFROMALL
</files>
<files parentnav.html>
$ALLOWFROMALL
</files>
<files parentnav_private.html>
$ALLOWFROMALL
</files>
"



INDEXHEAD="<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"
        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">
<head><title>$IMAGETITLE$WD</title>
<script type=\"text/javascript\" src=\"/~aoe/js/lightboxkey.js\"></script>
<script type=\"text/javascript\" src=\"/~aoe/js/loadtag.js\"></script>
<link type=\"text/css\" rel='stylesheet' href='$CSSURL/images.css' />
<meta name=\"editor\" content=\"$METAEDITOR\" />
<meta name=\"author\" content=\"`http_escape $METAAUTHOR`\" />
<!--#include virtual=\"$BASEURL/header.html\" -->
"

INDEXFOOT="<!--#include virtual=\"$BASEURL/footer.html\" --></body></html>"

################################
# subroutines
################################

#
# usage
# 

usage () {
cat << EOF
$0: [options] images...
-h	this usage
-p	all images are public
-r	always regenerate images
-L	allow access to original images to anonymous hosts
EOF
}

ls_lR ()
{
	local i me parent index 
	me=$1
	parent=$2
	index=$3

	if [ -n "$me" ]; then
		mename="${me%/}"
		mename="${mename//_/&nbsp;}"
		echo "<li><a href=\"$parent$me$index\">$mename</a>"
	else
		mename=`basename $PWD`
		mename="${mename//_/&nbsp;}"
		echo "<li><a href=\"$parent$me$index\">$mename</a>"
	fi
	dircontent=""
	for i in `ls -d */.`; do
		local i
		echo "$me (`pwd`)-> $i" 1>&2
		if ! grep -q "$NOPUBLICFILES" ${i}/index.html || (ls -d ${i}/*/. > /dev/null 2>&1) ; then
			pushd ${i} 1>&2
			dircontent="$dircontent"`ls_lR "${i%.}" "$parent$me" "$index"`
			popd 1>&2
		fi
	done
	if [ "x$dircontent" != "x" ]; then
		echo "<ul>$dircontent</ul>"
	fi
	echo "</li>"

}

#
# navigation: parent/sibling dirs
# 

parent_nav () 
{

# parent dir ..

PARENTNAV="$PARENTNAV
<td title=\"one dir up\" class=\"up\">
<a href=\"..\"><img class=\"nav\" alt=\"up\" width=\"32\" height=\"32\" src=\"$IMAGEURL/up_dark.png\" /></a><br/>
<a href=\"..\">
<span class=\"nav\">parent</span></a><br/>
"

if [ -f ../$INDEXPRIVATE ]; then
	PARENTNAVPRIVATE="$PARENTNAVPRIVATE
<td class=\"up\"><span title=\"one dir up\">
<a href=\"../$INDEXPRIVATE\"><img class=\"nav\" alt=\"up\" src=\"$IMAGEURL/up_dark.png\" /></a><br/>
<a href=\"../$INDEXPRIVATE\">
<span class=\"nav\">parent</span></a></p>
"
else
	PARENTNAVPRIVATE="$PARENTNAVPRIVATE
<td class=\"up\"><span title=\"one dir up\">
<a href=\"..\"><img class=\"nav\" alt=\"up\" width=\"32\" height=\"32\" src=\"$IMAGEURL/up_dark.png\" /></a><br/>
<a href=\"..\">
<span class=\"nav\">parent</span></a></p>
"
fi

# siblings


#if [ "x${PWD/*images/images}" != "ximages" ]; then
if [ "x$PWD" != "x$BASEDIR/$IMAGEDIR" ]; then

	PARENTNAVPRIVATEITEMS=""
	PARENTNAVITEMS=""
	pwd_base="`basename $PWD`"
for d in `find .. -maxdepth 1 -mindepth 1 -type d | sort`; do
	#if [ "x${d%../.*}" != "x" -a "x$d" != "x../$pwd_base" ]; then
	if [ "x${d%../.*}" != "x" ]; then
		# d="${d#../}"
		dnospace="${d//_/&nbsp;}"
		if [ -f "$d/$INDEXPRIVATE" ]; then
			PARENTNAVPRIVATEITEMS="$PARENTNAVPRIVATEITEMS
- <a href=\"$d/$INDEXPRIVATE\">
$dnospace</a>"
		else
			PARENTNAVPRIVATEITEMS="$PARENTNAVPRIVATEITEMS
- <a href=\"$d/\">
$dnospace</a>"
		fi
		PARENTNAVITEMS="$PARENTNAVITEMS
- <a href=\"$d/\">
$dnospace</a>"
	fi
done
fi
	
if [ -n "$PARENTNAVPRIVATEITEMS" ]; then
	PARENTNAVPRIVATE="$PARENTNAVPRIVATE
		<span class=\"navcomment\">siblings&gt;</span><br/>
		</td>
		<td class=\"up\">
		<span class=\"navcomment\">
		$PARENTNAVPRIVATEITEMS
		</span>"
fi
PARENTNAVPRIVATE="$PARENTNAVPRIVATE
	</td>"
if [ -n "$PARENTNAVITEMS" ]; then
	PARENTNAV="$PARENTNAV
		<span class=\"navcomment\">siblings&gt;</span><br/>
		</td>
		<td class=\"up\">
		<span class=\"navcomment\">
		$PARENTNAVITEMS
		</span>"
fi
PARENTNAV="$PARENTNAV
	</td>"

}

#
# navigation: subdirs
# 

subdir_nav () 
{

count_subdirs=0
SUBDIRNAVPRIVATE="<td class=\"down\"><span class=\"navcomment\">subdirs&gt;</span><p class=\"nav\">"
SUBDIRNAV="<td class=\"down\"><span class=\"navcomment\">subdirs&gt;</span><p class=\"nav\">"

for d in `find . -maxdepth 1 -mindepth 1 -type d | sort`; do
	if [ "x${d%./.*}" != "x" ]; then
		count_subdirs=$[ count_subdirs + 1 ]
		d="${d#./}"
		dnospace="${d//_/&nbsp;}"
		if [ -f "$d/$INDEXPRIVATE" ]; then
			SUBDIRNAVPRIVATE="$SUBDIRNAVPRIVATE
- <a href=\"$d/$INDEXPRIVATE\">
$dnospace</a>"
		else
			SUBDIRNAVPRIVATE="$SUBDIRNAVPRIVATE
- <a href=\"$d/\">
$dnospace</a>"
		fi
		SUBDIRNAV="$SUBDIRNAV
- <a href=\"$d/\">
$dnospace</a>"
	fi
	echo "
<files \"$d\">
$ALLOWFROMALL
</files>
" >> $HTACCESS

done

SUBDIRNAVPRIVATE="$SUBDIRNAVPRIVATE</p></td>"
SUBDIRNAV="$SUBDIRNAV</p></td>"

if [ $count_subdirs -eq 0 ]; then
	SUBDIRNAVPRIVATE=""
	SUBDIRNAV=""
fi

}

################################
# main program
################################

#
# argument processing
#

declare -a args 
for i in "$@"; do
	case $i in
		-h|-\?|--help)
			usage
			exit 0
			;;
		-p)
			PUBLIC=""
			touch $ALWAYSPUBLICFILE
			;;
		-L)
			ALLOWALLLARGE=1
			touch $ALLOWALLLARGEFILE
			;;
		-r)
			ALWAYS_REGEN=1
			;;
		-*)
			echo "$@: unknown"
			usage
			exit 1
			;;
		*)
			args=("${args[@]}" "$i")
			;;
	esac
done
#echo "${args[@]}"
#exit 1


rm -f $INDEXPUBLIC.tmp $INDEXPRIVATE.tmp $INDEXNONPUBLIC.tmp $HTACCESS.tmp

if [ -f $ALWAYSPUBLICFILE ]; then
	PUBLIC=""
fi

if [ -f $ALLOWALLLARGEFILE ]; then
	ALLOWALLLARGE=1
fi

echo -e "$HTHEAD" >> $HTACCESS.tmp

if [ "x$PUBLIC" = "x" ]; then
#	echo -e "<files ./$INDEXPRIVATE>\n$ALLOWFROMALL\n</files>" >> $HTACCESS.tmp
#else
#	echo -e "<files $INDEXPRIVATE>\nOrder Allow,Deny\n$DENYFROMALL\n</files>" >> $HTACCESS.tmp
true
fi


################################
# navigation
################################
LOGINHEAD="<hr/><p class=\"nav\">You are here: "
LOGINHEAD="$LOGINHEAD<a href=\"$BASEURL/\">$BASEURL/</a>"
LOGINHEADPRIVATE="$LOGINHEAD"

here="${PWD#$BASEDIR/}"
levels="${here//\//}"
levels=$[ ${#here} - ${#levels} + 1 ]
hereurl="$BASEURL"
thisurl="/"
for i in `seq 1 $levels`; do
	thisurl="$thisurl${here%%/*}/"
	LOGINHEAD="$LOGINHEAD<a href=\"$hereurl$thisurl\">${here%%/*}/</a>"
	if [ -f "$BASEDIR$thisurl$INDEXPRIVATE" -o "$BASEDIR$thisurl" = "$PWD/" ]; then
		LOGINHEADPRIVATE="$LOGINHEADPRIVATE<a href=\"$hereurl$thisurl$INDEXPRIVATE\">${here%%/*}/</a>"
	else
		LOGINHEADPRIVATE="$LOGINHEADPRIVATE<a href=\"$hereurl$thisurl\">${here%%/*}/</a>"
	fi
	here="${here#*/}"
done

LOGINHEAD="$LOGINHEAD</p>
<table class=\"loginhead\"><tr>"
LOGINHEADPRIVATE="$LOGINHEADPRIVATE</p>
<table class=\"loginhead\"><tr>"

#
# navigation: login
# 

LOGINHEADPRIVATE="$LOGINHEADPRIVATE
<td>
<a href=\"$INDEXPUBLIC\"><img class=\"nav\" alt=\"lock\" src=\"$IMAGEURL/lock_closed_dark.png\" /></a>
</td>"
LOGINHEADPRIVATE="$LOGINHEADPRIVATE
<td>
<a href=\"$INDEXPRIVATE\"><img class=\"nav\" alt=\"unlocked\" src=\"$IMAGEURL/lock_open.png\" /></a>
<br/>
<p class=\"nav\"><a href=\"$INDEXNONPUBLIC\">non public</a></p>
</td>"

LOGINHEAD="$LOGINHEAD
<td>
<a href=\"$INDEXPUBLIC\"><img class=\"nav\" alt=\"locked\" src=\"$IMAGEURL/lock_closed.png\" /></a>
</td>"
LOGINHEAD="$LOGINHEAD
<td>
<a href=\"$INDEXPRIVATE\"><img class=\"nav\" alt=\"unlock\" src=\"$IMAGEURL/lock_open_dark.png\" /></a>
</td>
"

parent_nav
subdir_nav

if [ "x$INCLUDEVIRTUALDIRS" = "x1" ]; then
	echo "$PARENTNAVPRIVATE" > ../parentnav_private.html
	echo "$SUBDIRNAVPRIVATE" > subdirnav_private.html
	echo "$PARENTNAV" > ../parentnav.html
	echo "$SUBDIRNAV" > subdirnav.html
	LOGINHEADPRIVATE="$LOGINHEADPRIVATE
<!--#include virtual=\"../parentnav_private.html\" -->
<!--#include virtual=\"subdirnav_private.html\" -->
</tr></table><hr/>"
	LOGINHEAD="$LOGINHEAD
<!--#include virtual=\"../parentnav.html\" -->
<!--#include virtual=\"subdirnav.html\" -->
</tr></table><hr/>"
else
	LOGINHEADPRIVATE="$LOGINHEADPRIVATE$PARENTNAVPRIVATE$SUBDIRNAVPRIVATE</tr></table><hr/>"
	LOGINHEAD="$LOGINHEAD$PARENTNAV$SUBDIRNAV</tr></table><hr/>"
fi

echo -e "$INDEXHEAD$LOGINHEAD" > $INDEXPUBLIC.tmp
echo -e "$INDEXHEAD$LOGINHEADPRIVATE" > $INDEXPRIVATE.tmp
echo -e "$INDEXHEAD$LOGINHEADPRIVATE" > $INDEXNONPUBLIC.tmp

if [ -f $INCLUDEHEADER ]; then
	cat $INCLUDEHEADER >> $INDEXPUBLIC.tmp
fi
if [ -f .private$INCLUDEHEADER ]; then
	cat .private$INCLUDEHEADER >> $INDEXPRIVATE.tmp
	cat .private$INCLUDEHEADER >> $INDEXNONPUBLIC.tmp
else
  cat $INCLUDEHEADER >> $INDEXPRIVATE.tmp
	cat $INCLUDEHEADER >> $INDEXNONPUBLIC.tmp

fi

########################################
# main: add image tables
########################################


count=0
count_private=0
count_nonpublic=0

# first pass: cache data
cache_data() {
	for n in `seq 0 $[ ${#args[@]} - 1 ]`; do
		i=${args[n]}
		COMMENT[n]=`/usr/bin/rdjpgcom "$i"`
		COMMENTFLOAT[n]=`http_escape "${COMMENT[n]}" | tr '\n' '/' | sed -e "s/\/*$PUBLIC//" -e 's/\/\/*/\//g' -e 's/\/* *$//g' -e 's/<.*>//g' `
		COMMENTTEXT[n]=`http_escape "${COMMENT[n]}" | sed  -e 's/$/<br\/>/g' ` 
		EXIF[n]=`(exiftags "$i"; exiftime -tg "$i") 2>/dev/null`
			
		if [ -n "${EXIF[n]}" -a "x${EXIF[n]/*Image Orientation: Top, Left-Hand*/OK}" != "xOK" ]; then
			#exiftran -ai "$i"
			exifautotran "$i"
		fi
		MED="${i%\.*}_med.jpg"
		SMALL="${i%\.*}_small.jpg"
		EXIFFILE="${i%\.*}_exif.txt"
		echo -n "scanning $i "
		if [ $ALWAYS_REGEN -eq 1 ]; then
			echo "removing (always) "
			rm -f "$MED" "$SMALL" "$EXIFFILE"
		fi
		if [ -s "$MED" ]; then
			djpeg -grayscale -scale 1/8 "$MED" > /dev/null || rm -f "$MED"
		fi
		if [ "$MED" -ot "$i" ]; then
			echo "$MED older than $i, removing"
			rm -f "$MED"
		fi
		if [ ! -s "$MED" ]; then
			djpeg "$i" | pnmscale -pixels $MEDPIX | cjpeg > "$MED"
			if [ -n $JHEAD ]; then
				$JHEAD -te "$i" "$MED"
			fi
		fi
		# test small version and erase if faulty
		if [ -s "$SMALL" ]; then
			djpeg -grayscale -scale 1/8 "$SMALL" >/dev/null || rm -f "$SMALL"
		fi
		if [ "$SMALL" -ot "$MED" ]; then
			echo "$SMALL older than $i, removing "
			rm -f "$SMALL"
		fi
		if [ ! -s "$SMALL" ]; then
			djpeg "$MED" | pnmscale -pixels $SMALLPIX | cjpeg > "$SMALL"
		fi
		if [ "$EXIFFILE" -ot "$i" ]; then
			echo "$EXIFFILE older than $i, removing "
			rm -f "$EXIFFILE"
		fi
		if d=`echo "${EXIF[n]}" | grep "Image Generated:"`; then
			d="${d#Image Generated: }"
		else
			d=`echo "${EXIF[n]}" | grep "Image Created:"`
			d="${d#Image Created: }"
		fi
		d="${d//[: ]/}"
# sort by date:
		if [ -z $d ]; then
			d=`date -r "$i" +%Y%m%d%H%M%S`
			echo set date to $d
		fi
		DATE[n]=$d
		if la=`echo "${EXIF[n]}" | grep "Latitude:"`; then
			lat=${EXIF[n]#*Latitude: } # text version
			lat=${lat%%?[A-Z]*}
			laq=${lat%% *} # quadrant
			la=${lat#$laq }
			lad=${la%%? *} # deg
			la=${la#$lad? }
			lam=${la%%? *} # min
			la=${la#$lam? }
			las=${la%% *} # s

			lot=${EXIF[n]#*Longitude: }
			lot=${lot%%?[A-Z]*} 
			loq=${lot%% *}
			lo=${lot#$loq }
			lod=${lo%%? *}
			lo=${lo#$lod? }
			lom=${lo%%? *}
			lo=${lo#$lom? }
			los=${lo%% *}

			alt=${EXIF[n]#*Altitude: } # text version
			alt=${alt%%?[A-Z]*} 
			if [ "x$alt" != "x" ]; then
				alt="Alt. $alt"
			fi

			COMMENTTEXT[n]="${COMMENTTEXT[n]}<br>Loc: $alt<br><a href=\"https://toolserver.org/~magnus/geo/geohack.php?pagename=$1&params=${lad}_${lam}_${las}_${laq}_${lod}_${lom}_${los}_${loq}\">${lad}° ${lam}' ${las%.*}&quot; ${laq} ${lod}° ${lom}' ${los%.*}&quot; ${loq}</a>"

		fi
		for n1 in `seq $n -1 1`; do
			if [ ${DATE[n1]} -lt ${DATE[n1-1]} ]; then
				tmp="${COMMENT[n1-1]}"
				COMMENT[n1-1]="${COMMENT[n1]}"
				COMMENT[n1]="$tmp"
				tmp="${COMMENTFLOAT[n1-1]}"
				COMMENTFLOAT[n1-1]="${COMMENTFLOAT[n1]}"
				COMMENTFLOAT[n1]="$tmp"
				tmp="${COMMENTTEXT[n1-1]}"
				COMMENTTEXT[n1-1]="${COMMENTTEXT[n1]}"
				COMMENTTEXT[n1]="$tmp"
				tmp="${EXIF[n1-1]}"
				EXIF[n1-1]="${EXIF[n1]}"
				EXIF[n1]="$tmp"
				tmp="${args[n1-1]}"
				args[n1-1]="${args[n1]}"
				args[n1]="$tmp"
				tmp="${DATE[n1-1]}"
				DATE[n1-1]="${DATE[n1]}"
				DATE[n1]="$tmp"
				echo -n "."
			fi
		done
		echo 
	done
	echo ${args[*]}
	for n in `seq 0 $[ ${#args[@]} - 1 ]`; do
		if echo "${COMMENT[n]}" | grep -E "^$PRIVATE$" ; then
			arglists[${#arglists[@]}]=$n
		else
			arglistp[${#arglistp[@]}]=$n
			if [ -z "$PUBLIC" -o "x${COMMENT[n]/*$PUBLIC*/public}" = "x$PUBLIC" ]; then
				arglista[${#arglista[@]}]=$n
			fi
		fi
	done
			
		
		
		

}

process_images() {
	declare -a arg
	eval "arg=($2)"
	type=$1
	
	echo looping ${arg[@]}
	echo input "$1" "$2"
	#if [ "x${arg[0]}" = "x" ]; then
	#	echo error: returning - nothing to process
	#	exit 1
	#fi
	case $type in
	public)
		INDEX=$INDEXPUBLIC
		THISLOGINHEAD=$LOGINHEAD
		;;
	private)
		INDEX=$INDEXPRIVATE
		THISLOGINHEAD=$LOGINHEADPRIVATE
		;;
	secret)
		INDEX=$INDEXNONPUBLIC
		THISLOGINHEAD=$LOGINHEADPRIVATE
		;;
	esac

	for n in `seq 0 $[${#arg[@]}-1]`; do
		indexsublist=${arg[n]}
		i=${args[indexsublist]}
		prevn=$[ (n+${#arg[@]}-1) % (${#arg[@]}) ]
		nextn=$[ (n           +1) % (${#arg[@]}) ]
		indexp=${arg[prevn]}
		indexn=${arg[nextn]}
		prev=${args[indexp]}
		next=${args[indexn]}

		case $type in
			public)
				HTML="${i%.*}.html"
				HTMLprev="${prev%\.*}.html"
				HTMLnext="${next%\.*}.html"
				;;
			private)
				HTML="${i%\.*}_private.html"
				HTMLprev="${prev%\.*}_private.html"
				HTMLnext="${next%\.*}_private.html"
				;;
			secret)
				HTML="${i%\.*}_nonpublic.html"
				HTMLprev="${prev%\.*}_nonpublic.html"
				HTMLnext="${next%\.*}_nonpublic.html"
				;;
		esac
	
		MED="${i%\.*}_med.jpg"
		SMALL="${i%\.*}_small.jpg"
		sizes="`(djpeg -v "$SMALL" > /dev/null) 2>&1`"
		SMALLWIDTH="${sizes#*width=}"
		SMALLWIDTH="${SMALLWIDTH%%,*}"
		SMALLHEIGHT="${sizes#*height=}"
		SMALLHEIGHT="${SMALLHEIGHT%%,*}"
		EXIFFILE="${i%\.*}_exif.txt"
		COMMENTthis="${COMMENT[indexsublist]}"
		COMMENTFLOATthis="${COMMENTFLOAT[indexsublist]}"
		COMMENTTEXTthis="${COMMENTTEXT[indexsublist]}"
		MEDprev="${prev%\.*}_med.jpg"
		SMALLprev="${prev%\.*}_small.jpg"
		EXIFFILEprev="${prev%\.*}_exif.txt"
		MEDnext="${next%\.*}_med.jpg"
		SMALLnext="${next%\.*}_small.jpg"
		EXIFFILEnext="${next%\.*}_exif.txt"
		COMMENTFLOATprev="${COMMENTFLOAT[indexp]}"
		COMMENTTEXTprev="${COMMENTTEXT[indexp]}"
		COMMENTFLOATnext="${COMMENTFLOAT[indexn]}"
		COMMENTTEXTnext="${COMMENTTEXT[indexn]}"
		# test medium version and erase if faulty

		if [ $DO_HTML -gt 0  -a "$HTML" -ot "$i" ]; then
			echo "$HTML older than $i, removing"
			rm -f "$HTML"
		fi
		if [ ! -s "$EXIFFILE" -a -n "${EXIF[indexsublist]}" ]; then
			echo "${EXIF[indexsublist]}" > "$EXIFFILE" 2>/dev/null
		fi


		ADD="<p class=\"further\">($[n+1]. "
		if [ "x$type" != "xpublic" ]; then
			ADD="$ADD<a href=\"$ROTATECGI?f=$i\">ed</a>"
		fi
		if [ -L $i ]; then
			BACKLINK=`readlink $i`
			BACKLINK=${BACKLINK%/*}
			ADD="$ADD/<a href=\"$BACKLINK\" title=\"symlink to $BACKLINK\">li</a>"
		fi

		if [ $ALLOWALLLARGE -eq 1 -o "x$type" != "xpublic" -o "x${COMMENTFLOATthis/*allowalllarge*/large}" = "xlarge" ]; then
			ADD="$ADD/<a href=\"$i\" >or</a>"
		fi
		if [  -n "${EXIF[indexsublist]}" ]; then
			ADD="$ADD/<a href=\"$EXIFFILE\">ex</a>"
		fi

# include lightbox rel in full scale link
		if [ "x$COMMENTFLOATthis" != "x" ]; then
			TITLEINC="title=\"$COMMENTFLOATthis\""
		else
			TITLEINC=""
		fi
		if [ $ALLOWALLLARGE -eq 1 -o "x$type" != "xpublic" -o "x${COMMENTFLOATthis/*allowalllarge*/large}" = "xlarge" ]; then
			ADD="$ADD <span class=\"lightbox\"><a href=\"$i\" $TITLEINC rel=\"lightbox[]\" >lightbox</a></span>"
		else
			ADD="$ADD <span class=\"lightbox\"><a href=\"$MED\" $TITLEINC rel=\"lightbox[]\" >lightbox</a></span>"
		fi
		ADD="$ADD)</p>"
		
		if [ $DO_HTML -gt 0 ]; then
			LINK="$HTML"
			LINKprev="$HTMLprev"
			LINKnext="$HTMLnext"
		else
			LINK="$MED"
		fi
		ENTRY1="<table class=\"thumb\"><tbody class=\"upper\"><tr><td><a name=\"$i\" /><a href=\"$LINK\"><img alt=\"$COMMENTFLOATthis\" title=\"$COMMENTFLOATthis\" width=\"$SMALLWIDTH\" height=\"$SMALLHEIGHT\" src=\"$SMALL\" /></a></td></tr></tbody><tbody class=\"lower\"><tr>"
		ENTRY2="<p class=\"i\">$COMMENTTEXTthis</p></td>"
		ENTRY3="</tr></tbody></table>"
		
		ENTRY="$ENTRY1<td>$ADD$ENTRY2$ENTRY3"

# large image html page
		if [ $DO_HTML -gt 0 ]; then
			ENTRYLARGE="$ENTRY1
			<td><table><tr>
			<td class=\"htmlnav\"><a href=\"$LINKprev\"><img alt=\"$COMMENFLOATprev\" title=\"$COMMENTFLOATprev\" src=\"$SMALLprev\" /></a></td>
			<td class=\"htmlnav\">$ADD
			$ENTRY2
			<td class=\"htmlnav\"><a href=\"$LINKnext\"><img alt=\"$COMMENTFLOATnext\" title=\"$COMMENTFLOATnext\" src=\"$SMALLnext\" /></a></td>
			</tr></table></td>
			$ENTRY3
			"
			if [ $ALLOWALLLARGE -eq 1 -o "x$type" != "xpublic" -o "x${COMMENTFLOATthis/*allowalllarge*/large}" = "xlarge" ]; then
				ENTRYLARGE="${ENTRYLARGE/$HTML/$i}"
			else
				ENTRYLARGE="${ENTRYLARGE/$HTML/$MED}"
			fi
			echo "$type $i: $COMMENTthis"
			if [ "x$type" = "x$PUBLIC" -o "x$PUBLIC" = "x" ]; then
				echo -e "<files ${i%\.*}_*jpg>\n$ALLOWFROMALL\n</files>" >> $HTACCESS
				echo -e "<files ${i%\.*}_exif.txt>\n$ALLOWFROMALL\n</files>" >> $HTACCESS
				echo -e "<files $HTML>\n$ALLOWFROMALL\n</files>" >> $HTACCESS
				if [ $ALLOWALLLARGE -eq 1 -o "x${COMMENTFLOATthis/*allowalllarge*/large}" = "xlarge" ]; then
					echo -e "<files ${i}>\n$ALLOWFROMALL\n</files>" >> $HTACCESS
				fi
			fi


			if [ "x$type" = "xpublic" ]; then
				# don't show allowalllarge tag in public files (already has orig link)
				COMMENTTEXTthis="${COMMENTTEXTthis//allowalllarge/}"
				COMMENTFLOATthis="${COMMENTFLOATthis//allowalllarge/}"
				COMMENTFLOATprev="${COMMENTFLOATprev//allowalllarge/}"
				COMMENTFLOATnext="${COMMENTFLOATnext//allowalllarge/}"

				COMMENTTEXTthis="${COMMENTTEXTthis//$PUBLIC/}"
				COMMENTFLOATthis="${COMMENTFLOATthis//$PUBLIC/}"
				COMMENTFLOATprev="${COMMENTFLOATprev//$PUBLIC/}"
				COMMENTFLOATnext="${COMMENTFLOATnext//$PUBLIC/}"

				ENTRY="${ENTRY//allowalllarge/}"
				ENTRY="${ENTRY//$PUBLIC/}"
				ENTRYLARGE="${ENTRYLARGE//allowalllarge/}"
				ENTRYLARGE="${ENTRYLARGE//public/}"
			fi

			ENTRYLARGE="${ENTRYLARGE/$SMALL/$MED}"
			ENTRYLARGE="${ENTRYLARGE/width=\"$SMALLWIDTH\" /}"
			ENTRYLARGE="${ENTRYLARGE/height=\"$SMALLHEIGHT\" /}"
			# ENTRYLARGE="${ENTRYLARGE/width=\"+([0-9])\" height=\"+([0-9])\"//}"
			ENTRYLARGE="${ENTRYLARGE//class=\"thumb\"/class=\"foto\"}"
			# hack: make prev/current image
			echo "$INDEXHEAD
			<table class=\"nav\"><tbody>
			<tr><td><a href=\"../$INDEX\">..<br/>dir<br/>up</a><br/></td></tr>
			<tr><td><br/><a href=\"$LINKprev\">prev<br/>&lt;&lt;</a></td></tr>
			<tr><td><a href=\"$LINKnext\">&gt;&gt;<br/>next</a></td></tr>
			<tr><td><a href=\"$INDEX#$i\"><br/>in-<br/>dex<br/>__</a></td></tr>
			<tr><td><p></p><p>$[n+1]/${#arg[@]}</p></td></tr>
			</tbody></table>
			$ENTRYLARGE
			<p></p>
			$THISLOGINHEAD$INDEXFOOT
			" > "$HTML"
			echo "$ENTRY" >> $INDEX.tmp
		fi

	done
	echo \$INDEX is $INDEX
	echo mv $INDEX.tmp $INDEX
	mv $INDEX.tmp $INDEX
}

########################################
# main
########################################

cache_data
HTACCESSorig="$HTACCESS"
HTACCESS="$HTACCESS.tmp"
process_images secret '${arglists[@]}' 
process_images private '${arglistp[@]}' 
process_images public '${arglista[@]}' 
# footer
cat $HTBASE >> $HTACCESS
mv $HTACCESS $HTACCESSorig

if [ ${#arglista[@]} -eq 0 -o ${#arglistp[@]} -eq 0 -o ${#arglists[@]} -eq 0 ]; then
	lslr=`ls_lR "" "" ""`
fi
	
if [ ${#arglista[@]} -gt 0 ]; then
	echo -e "$LOGINHEAD$COPYRIGHT" >> $INDEXPUBLIC
else
	echo -e "$NOPUBLICFILES" >> $INDEXPUBLIC
	if [ "x$lslr" != "x" ]; then 
		echo "<ul>$lslr</ul>" >> $INDEXPUBLIC
	fi
fi
if [ ${#arglistp[@]} -gt 0 ]; then
	echo -e "$LOGINHEADPRIVATE$COPYRIGHT" >> $INDEXPRIVATE
else
	echo -e "$NOPUBLICFILES" >> $INDEXPRIVATE
	if [ "x$lslr" != "x" ]; then 
		echo "<ul>$lslr</ul>" >> $INDEXPRIVATE
	fi
fi
if [ ${#arglists[@]} -gt 0 ]; then
	echo -e "$LOGINHEADPRIVATE$COPYRIGHT" >> $INDEXNONPUBLIC
else
	echo -e "$NOPUBLICFILES" >> $INDEXNONPUBLIC
	if [ "x$lslr" != "x" ]; then 
		echo "<ul>$lslr</ul>" >> $INDEXNONPUBLIC
	fi
fi

echo -e "$INDEXFOOT" >> $INDEXPUBLIC
echo -e "<p><a href=\"$ROTATECGI?rehash=1\">rehash dir</a></p>$INDEXFOOT" >> $INDEXPRIVATE
echo -e "$INDEXFOOT" >> $INDEXNONPUBLIC

