#ifndef _aviutil_h
#define _aviutil_h
#include <config.h>
#include <string>

extern unsigned int (*localcount)();
extern long long (*longcount)();

class CPU_Info
{
    double freq;
    int have_tsc;
    int have_mmx;
    static double old_freq();
    static long long longcount_notsc();
    static long long longcount_tsc();
    static unsigned int localcount_notsc();
    static unsigned int localcount_tsc();
public:
    CPU_Info();
    int HaveMMX() const {return have_mmx;}
    int HaveTSC() const {return have_tsc;}
    operator double() const {return freq;}
};

extern CPU_Info freq;

inline float to_float(long long t2, long long t1)
{
    long long qw=t2-t1;
    qw=(long long)(qw/freq);//milliseconds;
    return ((int)qw)/1000.;
}

namespace Registry
{
    int WriteInt(std::string appname, std::string valname, int value);
    int ReadInt(std::string appname, std::string valname, int def_value);
    int WriteFloat(std::string appname, std::string valname, float value);
    float ReadFloat(std::string appname, std::string valname, float def_value);
    int WriteString(std::string appname, std::string valname, std::string value);
    std::string ReadString(std::string appname, std::string valname, std::string def_value);
    int WriteData(std::string appname, std::string valname, const void* data, int size);
    int ReadData(std::string appname, std::string valname, void* data, int size);
};
#endif
