#include "colormodels.h"
#include "dv.h"
#include "funcprotos.h"
#include "quicktime.h"

static int quicktime_delete_codec_dv(quicktime_video_map_t *vtrack)
{
	quicktime_dv_codec_t *codec = ((quicktime_codec_t*)vtrack->codec)->priv;

	if(codec->dv) dv_delete(codec->dv);
	free(codec->temp_frame);
	free(codec->data);
	free(codec);
	return 0;
}

static int quicktime_decode_dv(quicktime_t *file, unsigned char **row_pointers, int track)
{
	long bytes;
	quicktime_video_map_t *vtrack = &(file->vtracks[track]);
	quicktime_dv_codec_t *codec = ((quicktime_codec_t*)vtrack->codec)->priv;
	int width = vtrack->track->tkhd.track_width;
	int height = vtrack->track->tkhd.track_height;
	int result = 0;

	quicktime_set_video_position(file, vtrack->current_position, track);
	bytes = quicktime_frame_size(file, vtrack->current_position, track);
	result = !quicktime_read_data(file, codec->data, bytes);

	if(codec->dv)
	{
		if(file->color_model == BC_YUV422P &&
			file->in_x == 0 && 
			file->in_y == 0 && 
			file->in_w == width &&
			file->in_h == height &&
			file->out_w == width &&
			file->out_h == height)
		{
			dv_read_video(codec->dv, 
				row_pointers, 
				codec->data, 
				bytes, 
				BC_YUV422P);
		}
		else
		{
//printf("quicktime_decode_dv %d\n", file->color_model);
			dv_read_video(codec->dv, 
				codec->temp_rows, 
				codec->data, 
				bytes, 
				BC_YUV422P);

			cmodel_transfer(row_pointers, 
				codec->temp_rows,
				row_pointers[0],
				row_pointers[1],
				row_pointers[2],
				codec->temp_rows[0],
				codec->temp_rows[1],
				codec->temp_rows[2],
				file->in_x, 
				file->in_y, 
				file->in_w, 
				file->in_h,
				0, 
				0, 
				file->out_w, 
				file->out_h,
				BC_YUV422P, 
				file->color_model,
				0,
				width,
				file->out_w);
		}
	}

	return result;
}

static int quicktime_encode_dv(quicktime_t *file, unsigned char **row_pointers, int track)
{
	fprintf(stderr, "quicktime_encode_dv: DV encoder not available\n");
	return 1;
}

// Logic: DV contains a mixture of 420 and 411 so can only output 444 or 422

static int quicktime_reads_colormodel_dv(quicktime_t *file, 
		int colormodel, 
		int track)
{
	return (colormodel == BC_YUV888 ||
		colormodel == BC_YUV422 ||
		colormodel == BC_YUV422P);
}

void quicktime_init_codec_dv(quicktime_video_map_t *vtrack)
{
	quicktime_dv_codec_t *codec;
	int i;

/* Init public items */
	((quicktime_codec_t*)vtrack->codec)->priv = calloc(1, sizeof(quicktime_dv_codec_t));
	((quicktime_codec_t*)vtrack->codec)->delete_vcodec = quicktime_delete_codec_dv;
	((quicktime_codec_t*)vtrack->codec)->decode_video = quicktime_decode_dv;
	((quicktime_codec_t*)vtrack->codec)->encode_video = quicktime_encode_dv;
	((quicktime_codec_t*)vtrack->codec)->decode_audio = 0;
	((quicktime_codec_t*)vtrack->codec)->encode_audio = 0;
	((quicktime_codec_t*)vtrack->codec)->reads_colormodel = quicktime_reads_colormodel_dv;

/* Init private items */
	codec = ((quicktime_codec_t*)vtrack->codec)->priv;
	codec->dv = dv_new();
	codec->temp_frame = calloc(1, 720 * 576 * 2);
	codec->data = calloc(1, 140000);
	codec->temp_rows[0] = codec->temp_frame;
	codec->temp_rows[1] = codec->temp_frame + 720 * 576;
	codec->temp_rows[2] = codec->temp_frame + 720 * 576 + 720 * 576 / 2;
}
