/********************************************************

	Exception object
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/
#ifndef __except_h
#define __except_h

#include <iostream>
#include <cstring>

/**
 *
 *   The idea is to use error codes for non-fatal problems
 * ( for example, problem in decompressing one frame is not fatal
 * for video decoder ) and exceptions for problems which leave
 * object in unusable state. GenError is an intermediate case.
 *
 */

class BaseError
{
    char* module;
    char* description;
    const char* file;
    char* severity;
    int line;
public:
    ~BaseError()
    {
	delete module;
	delete description;
	delete severity;
    }	
    BaseError(const char* sev, const char* mod, const char* desc, const char* f=0, int l=0):file(f),line(l)
    {
	module=new char[std::strlen(mod)+1];
	std::strcpy(module, mod);
	severity=new char[std::strlen(sev)+1];
	std::strcpy(severity, sev);
	description=new char[std::strlen(desc)+1];
	std::strcpy(description, desc);
    }
    BaseError(const BaseError& f)
    {
	module=new char[std::strlen(f.module)+1];
	std::strcpy(module, f.module);
	description=new char[std::strlen(f.description)+1];
	std::strcpy(description, f.description);
	severity=new char[std::strlen(f.severity)+1];
	std::strcpy(severity, f.severity);
	file=f.file;
	line=f.line;
    }
    void Print()
    {
	std::cerr<<module<<": ";
	std::cerr<<severity;
	std::cerr<<": "<<description<<std::endl;
    }
    void PrintAll()
    {
	std::cerr<<module<<": ";
	std::cerr<<severity;
	std::cerr<<": "<<description;
	if(file)std::cerr<<" at "<<file;
	if(line)std::cerr<<":"<<line;
	std::cerr<<std::endl;
    }		
    const char* GetModule() const{return module;}
    const char* GetDesc() const{return description;}
};
class FatalError: public BaseError
{
public:
    FatalError(const char* mod, const char* desc, const char* f=0, int l=0):BaseError("FATAL",mod,desc,f,l){}
    FatalError(const FatalError& f):BaseError(f){}
};
class GenError: public BaseError
{
public:
    GenError(const char* mod, const char* desc, const char* f=0, int l=0):BaseError("WARNING",mod,desc,f,l){}
    GenError(const GenError& f):BaseError(f){}
};

#define FATAL(X) FatalError(__MODULE__,X,__FILE__,__LINE__)
#define WARNING(X) GenError(__ERR_MODULE__,X,__FILE__,__LINE__)
#define MEMORY_FATAL FATAL("Out of memory")
/*
class Unsigned
{
    int i;
public:
    Unsigned(){}
    Unsigned(const Unsigned& ref):i(ref.i)
    {
	if(i<0)
	    throw FatalError("Unsigned value", "Range error", __FILE__, __LINE__);
    }
    Unsigned(int ref):i(ref)
    {
	if(i<0)
	    throw FatalError("Unsigned value", "Range error", __FILE__, __LINE__);
    }
    operator unsigned() const {return (unsigned)i;}
    bool operator<(const Unsigned& e) const {return i<e.i;}
    bool operator<(int e) const {return i<e;}
    bool operator<(unsigned e) const {return i<e;}
    Unsigned& operator++(int){i++;return *this;}
    Unsigned& operator++(){i++;return *this;}
    Unsigned operator-(const Unsigned& e) const 
    {
	return Unsigned(i-e.i);
    }	
    Unsigned operator-(int e) const 
    {
	return Unsigned(i-e);
    }	
    Unsigned operator+(const Unsigned& e) const 
    {
	return Unsigned(i+e.i);
    }	
    Unsigned& operator+=(const Unsigned& e)
    {
	i+=e.i;
	return *this;
    }
    Unsigned& operator-=(const Unsigned& e)
    {
	i-=e.i;
	if(i<0)
	    throw FatalError("Unsigned value", "Range error", __FILE__, __LINE__);
	return *this;
    }
//    operator int(){return i;}
//    unsigned& operator=(const unsigned& ref){i=ref; return *this;}
};
*/
typedef unsigned Unsigned;
#endif
