/* readpic.c, read source pictures                                          */

/* Copyright (C) 1996, MPEG Software Simulation Group. All Rights Reserved. */

/*
 * Disclaimer of Warranty
 *
 * These software programs are available to the user without any license fee or
 * royalty on an "as is" basis.  The MPEG Software Simulation Group disclaims
 * any and all warranties, whether express, implied, or statuary, including any
 * implied warranties or merchantability or of fitness for a particular
 * purpose.  In no event shall the copyright-holder be liable for any
 * incidental, punitive, or consequential damages of any kind whatsoever
 * arising from the use of these programs.
 *
 * This disclaimer of warranty extends to the user of these programs and user's
 * customers, employees, agents, transferees, successors, and assigns.
 *
 * The MPEG Software Simulation Group does not represent or warrant that the
 * programs furnished hereunder are free of infringement of any third-party
 * patents.
 *
 * Commercial implementations of MPEG-1 and MPEG-2 video, including shareware,
 * are subject to royalty fees to patent holders.  Many of these patents are
 * general enough such that they are unavoidable regardless of implementation
 * design.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "colormodels.h"
#include "config.h"
#include "global.h"
#ifndef DONT_USE_AVI
#include "aviplugin.h"
#endif
#ifndef DONT_USE_NUV
#include "../rtjpeg/RTjpeg.h"
#endif
#include "areaDeinterlace.h"

int yuvscaler(char **in, char **out,long int xin,long int yin, long int xout, long int yout, long int xoff, long int yoff, long int width, long int height);
#ifndef DYNAMIC_LOADING
#ifndef DONT_USE_NUV
void read_rtjpeg(frame, number);
#endif
#ifndef DONT_USE_AVI
void read_avi(frame, number);
#endif
#endif

#ifdef VIDEO_EXPORT_ONLY
#define printf(x...) (fprintf(stderr,x))
#endif
	
#define MAX_READAHEAD 3

static void read_quicktime(frame, number)
unsigned char *frame[];
long number;
{
	int i, j;
	int r, g, b;
	int y, u, v;
	double cr, cg, cb, cu, cv;
	char name[128];
	unsigned char *yp, *up, *vp;
	static unsigned char *u444, *v444, *u422, *v422;
	static double coef[7][3] = {
		{0.2125,0.7154,0.0721}, /* ITU-R Rec. 709 (1990) */
		{0.299, 0.587, 0.114},  /* unspecified */
		{0.299, 0.587, 0.114},  /* reserved */
		{0.30,  0.59,  0.11},   /* FCC */
		{0.299, 0.587, 0.114},  /* ITU-R Rec. 624-4 System B, G */
		{0.299, 0.587, 0.114},  /* SMPTE 170M */
		{0.212, 0.701, 0.087}}; /* SMPTE 240M (1987) */
	static long rtoy_tab[256], gtoy_tab[256], btoy_tab[256];
	static long rtou_tab[256], gtou_tab[256], btou_tab[256];
	static long rtov_tab[256], gtov_tab[256], btov_tab[256];
	static int need_tables = 1;   // Initialize tables on first read
	int colormodel;
	long real_number;

	i = matrix_coefficients;
	if(i > 8) i = 3;

	cr = coef[i - 1][0];
	cg = coef[i - 1][1];
	cb = coef[i - 1][2];
	cu = 0.5 / (1.0 - cb);
	cv = 0.5 / (1.0 - cr);

// Allocate output buffers
	if(chroma_format == CHROMA444)
	{
// Not supported by libMPEG3
    	u444 = frame[1];
    	v444 = frame[2];
	}
	else
	{
    	if (!u444)
    	{
    		if (!(u444 = (unsigned char *)malloc(xin*yin)))
        		error("malloc failed");
    		if (!(v444 = (unsigned char *)malloc(xin*yin)))
        		error("malloc failed");
    		if (chroma_format==CHROMA420)
    		{
        		if (!(u422 = (unsigned char *)malloc((xin>>1)*yin)))
        			error("malloc failed");
        		if (!(v422 = (unsigned char *)malloc((xin>>1)*yin)))
        			error("malloc failed");
    		}
    	}
	}

// Initialize YUV tables
	if(need_tables)
	{
		for(i = 0; i < 256; i++)
		{
			rtoy_tab[i] = (long)( 0.2990 * 65536 * i);
			rtou_tab[i] = (long)(-0.1687 * 65536 * i);
			rtov_tab[i] = (long)( 0.5000 * 65536 * i);

			gtoy_tab[i] = (long)( 0.5870 * 65536 * i);
			gtou_tab[i] = (long)(-0.3320 * 65536 * i);
			gtov_tab[i] = (long)(-0.4187 * 65536 * i);

			btoy_tab[i] = (long)( 0.1140 * 65536 * i);
			btou_tab[i] = (long)( 0.5000 * 65536 * i);
			btov_tab[i] = (long)(-0.0813 * 65536 * i);
		}
		need_tables = 0;
	}
/*
// Get the color model in order or preference
	real_number = (long)((double)quicktime_frame_rate(qt_file, 0) / 
			frame_rate * 
			number + 
			0.5);
//printf("\n 1 %d\n", real_number);
	quicktime_set_video_position(qt_file, 
		real_number, 
		0);
*/
//printf("readframe 1 %p %p %p\n", frame[0], frame[1], frame[2]);
	quicktime_decode_scaled(qt_file, 
		0,                    /* Location of input frame to take picture */
		0,
		xin,
		yin,
		xin,
		yin,
		BC_YUV420P,             /* One of the color models defined above */
		frame, 
		0);
//printf("readframe 2\n");
}

static void read_mpeg(long number, unsigned char *frame[])
{
	int i;
	int chrom_hsize, chrom_vsize;
	char name[128];
	long real_number;

	chrom_hsize = (chroma_format == CHROMA444) ? xin
                                        	 : xin>>1;
	chrom_vsize = (chroma_format != CHROMA420) ? yin
                                        	 : yin>>1;

// Normalize frame_rate
	real_number = (long)((double)mpeg3_frame_rate(mpeg_file, 0) / 
		frame_rate * 
		number + 
		0.5);

	if (mpeg3_get_frame(mpeg_file, 0) <= real_number)
	  mpeg3_set_frame(mpeg_file, real_number, 0);

	while(mpeg3_get_frame(mpeg_file, 0) <= real_number)
		mpeg3_read_yuvframe(mpeg_file,
			frame[0],
			frame[1],
			frame[2],
			0,
			0,
			xin,
			yin,
			0);
	if(mpeg3_end_of_video(mpeg_file, 0)) frames_scaled = 0; /* Terminate encoding */
/*
 * 
 *
 * 	border_extend(frame[0],xin,yin,xin,yin);
 * 
 * 
 * 	border_extend(frame[1],chrom_hsize,chrom_vsize,chrom_xin,chrom_yin);
 * 
 * 
 * 	border_extend(frame[2],chrom_hsize,chrom_vsize,chrom_xin,chrom_yin);
 */

}


void readframe(int frame_num, uint8_t *frame[])
{
	static int mostrecent = -1;
	static int mostrecentp = -1;
	static size_t bufsize;
	static uint8_t *yuv[MAX_READAHEAD][3];
	static uint8_t *scaler[3],*buffer[3];
	static int eof_point=-1;
	int i,j;
	static char stamp[32];
	static int scaling;
	int n;

	
	frame_num += start_frame; // grmbl, avi does it
	n = frame_num % (2*READ_LOOK_AHEAD);
//	fprintf(stderr,"\n reading up to frame %i ...",frame_num);
	if (mostrecent == -1) { // first frame to encode, number may be != 0
		for (i=0;i<MAX_READAHEAD;i++)
			for (j=0;j<3;j++) {
				yuv[i][j]=(char *)malloc((j==0)?width*height:width*height/4);
				if (!yuv[i][j])
					error("mallocing image buffers");
			}
		for (j=0;j<3;j++) {
			buffer[j]=(char *)malloc((j==0)?xin*yin:xin*yin/4);
			scaler[j]=(char *)malloc((j==0)?width*height:width*height/4);
			if (!buffer[j] || !scaler[j])
				error("mallocing image buffers");
		}
		mostrecent=frame_num-1;
	        mostrecentp=-1;
		if (xout)
			scaling=1;
	}

      while (mostrecent < frame_num && frames_scaled && (eof_point != mostrecentp || mostrecentp == -1 )) {
        mostrecentp=(mostrecentp + 1) % MAX_READAHEAD;
        mostrecent++;

//	fprintf(stderr,"%i (%i), ", mostrecent, mostrecentp);
	if (scaling) {
		frame[0] = buffer[0];
		frame[1] = buffer[1];
		frame[2] = buffer[2];
        } else {
		frame[0] = yuv[mostrecentp][0];
		frame[1] = yuv[mostrecentp][1];
		frame[2] = yuv[mostrecentp][2];
	}
	switch (inputtype)
	{
/*
 * 		case T_Y_U_V:
 * 			read_y_u_v(fname, frame);
 * 			break;
 * 		case T_YUV:
 * 			read_yuv(fname, frame);
 * 			break;
 * 		case T_PPM:
 * 			read_ppm(fname, frame);
 * 			break;
 */
		case T_QUICKTIME:
			read_quicktime(frame, mostrecent);
			break;
		case T_MPEG:
			read_mpeg(mostrecent, frame);
			break;
#ifndef DYNAMIC_LOADING
#ifndef DONT_USE_AVI
		case T_AVI:
			read_avi(frame, mostrecent);
			break;
#endif
#ifndef DONT_USE_NUV
		case T_RTJPEG:
			read_rtjpeg(frame, mostrecent);
			break;
#endif
#else
		case T_DYNAMIC:
			(codecs[video_in_module].read_frame)(frame, mostrecent);
//			eof_flag[mostrecentp]=(codecs[video_in_module].eof_file)();
			if((codecs[video_in_module].eof_file)())
				eof_point = mostrecentp; 
			break;
#endif
		default:
			break;
  	}

        // sometimes even full sized AVI's have intelacing artefacts
        if ((yin > 288 && deinterlace) || (deinterlace == 1)) {
          AreaBasedDeinterlacerYUV420(frame[0], xin, yin);
        }

	if (scaling) {
//		fprintf(stderr,"              scaling %ix%i to %ix%i+%i+%i@%ix%i(=%ix%i)\n", xin, yin,                     /* insize */ cutwidth, cutheight, offx, offy,/*scale window*/ width,height, xout, yout);/* outsize */
		yuvscaler(&buffer,&scaler,
			  xin, yin,                     /* insize */
			                   width, height,/* outsize */
			  offx, offy, cutwidth, cutheight);/*scale window*/
		memcpy(yuv[mostrecentp][0],scaler[0],width*height);
		memcpy(yuv[mostrecentp][1],scaler[1],width*height/4);
		memcpy(yuv[mostrecentp][2],scaler[2],width*height/4);
	} 
		

	if (timestamptype) {
	  switch (timestamptype) {
	    case TIMESTAMP:             
		snprintf(stamp, 32, "%2ld:%02ld:%02ld.%02ld",
		(long int)mostrecent/(long int)(frame_rate*3600),
		(long int)(mostrecent/(frame_rate*60)) % (long int)(frame_rate*3600),
		(long int)(mostrecent/frame_rate)%(long int)(frame_rate*60),
		(long int)(mostrecent)%(long int)(frame_rate));
		break;
	    default:
	    case FRAMENUMSTAMP:                 
		snprintf(stamp, 32, "%5ld", mostrecent);
		break;
	  }
	  timestamp(yuv[mostrecentp],stamp);
	}
      }

	{
	  int p;

	  // fprintf(stderr," - returning (l: %ix%i, c:%ix%i) buffer %i in slot %i\n",
          //         width, height, chrom_width, chrom_height, p, n);

	  p=(mostrecentp - (mostrecent - frame_num) + MAX_READAHEAD)%MAX_READAHEAD;

#ifdef DYNAMIC_LOADING
	  if (eof_point == p)
		  frames_scaled=0; /* bad old hack for eof */
#endif
	  memcpy(frame_buffers[n][0],yuv[p][0],width*height);
	  memcpy(frame_buffers[n][1],yuv[p][1],chrom_width*chrom_height);
	  memcpy(frame_buffers[n][2],yuv[p][2],chrom_width*chrom_height);
	  /*
	    memcpy(yuv[p][0],&frame_buffers[n][0],width*height);
	    memcpy(yuv[p][1],&frame_buffers[n][1],chrom_width*chrom_height);
	    memcpy(yuv[p][2],&frame_buffers[n][2],chrom_width*chrom_height);
	  */
        }
        frame[0] = frame_buffers[n][0];
        frame[1] = frame_buffers[n][1];
        frame[2] = frame_buffers[n][2];

}
