/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] = "$Id: util.c,v 1.5 1999/09/13 11:17:35 root Exp $";

/*
 * $Log: util.c,v $
 * Revision 1.5  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.4  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.3  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"


unsigned char ethtoaret[1024];

unsigned char *
ethtoa (void *in)
{
  unsigned char *p = (unsigned char *) in;
  int i = ETH_ALEN;
  int len = 0;

  len += sprintf (ethtoaret + len, "%02x", *(p++));

  while (--i)
    len += sprintf (ethtoaret + len, ":%02x", *(p++));

  return (ethtoaret);
}

void
daemonize (void)
{
  int fd;

  switch (fork ())
    {
    case 0:
      break;
    case -1:
      openlog ("rpld", LOG_PID, LOG_DAEMON);
      syslog (LOG_ERR, "fork failed: %m");
      exit (1);
    default:
      exit (0);
    }

  setpgrp ();

  fd = open ("/dev/null", O_RDWR);
  dup2 (fd, 0);
  dup2 (fd, 1);
  dup2 (fd, 2);
  close (fd);
}
