#ifndef f_AVIPIPE_H
#define f_AVIPIPE_H

#include <windows.h>

class AVIPipe {
private:
	static char me[];

	HANDLE				hEventRead, hEventWrite;
	CRITICAL_SECTION	critsec;

	volatile struct AVIPipeBuffer {
		void	*data;
		long	size;
		long	len;
		long	sample;
		long	id;
		int		iExdata;
	} *pBuffers;

	int		num_buffers;
	long	round_size;

	long	cur_read;
	long	cur_write;

	long	total_audio;

	volatile char	finalize_state;

	enum {
		FINALIZE_TRIGGERED		= 1,
		FINALIZE_ACKNOWLEDGED	= 2,
		FINALIZE_ABORTED		= 4,
		SYNCPOINT_TRIGGERED		= 8,
		SYNCPOINT_ACKNOWLEDGED	= 16,
	};

public:
	AVIPipe(int buffers, long roundup_size);
	~AVIPipe();

	BOOL isOkay();
	BOOL isFinalized();
	BOOL isNoMoreAudio();

	void *getWriteBuffer(long len, int *handle_ptr, DWORD timeout);
	void postBuffer(long len, long samples, int exdata, int handle);
	void *getReadBuffer(long *len_ptr, long *samples_ptr, int *exdata_ptr, int *handle_ptr, DWORD timeout);
	void releaseBuffer(int handle);
	void finalize();
	void abort();
	bool sync();
	void syncack();
};

#endif
