#ifndef f_VIRTUALDUB_COMMAND_H
#define f_VIRTUALDUB_COMMAND_H

#include <windows.h>
#include <vfw.h>

class InputFile;
class AVIOutput;
class VideoSource;
class AudioSource;
class IDubber;
class DubOptions;
class FrameSubset;

extern InputFile			*inputAVI;

extern AVIOutput			*outputAVI;

extern VideoSource			*inputVideoAVI;

extern AudioSource			*inputAudio;
extern AudioSource			*inputAudioAVI;
extern AudioSource			*inputAudioWAV;

extern FrameSubset			*inputSubset;

enum {
	AUDIOIN_NONE	= 0,
	AUDIOIN_AVI		= 1,
	AUDIOIN_WAVE	= 2,
};

extern int					audioInputMode;
extern IDubber				*g_dubber;

extern COMPVARS			g_Vcompression;
extern WAVEFORMATEX		*g_ACompressionFormat;
extern DWORD			g_ACompressionFormatSize;

extern BOOL				g_drawDecompressedFrame;
extern BOOL				g_showStatusWindow;
extern BOOL				g_syncroBlit;
extern BOOL				g_vertical;

///////////////////////////

enum {
	FILETYPE_AUTODETECT		= 0,
	FILETYPE_AVI			= 1,
	FILETYPE_MPEG			= 2,
	FILETYPE_ASF			= 3,
	FILETYPE_STRIPEDAVI		= 4,
};

void OpenAVI(char *szFile, int iFileType, bool fExtendedOpen, bool fQuiet=false, bool fAutoscan=false, const char *pInputOpts=0);
void AppendAVI(const char *pszFile);
void AppendAVIAutoscan(const char *pszFile);
void SetAudioSource();
void CloseAVI();
void OpenWAV(char *szFile);
void CloseWAV();
void CloseNewAVI();
void SaveWAV(char *szFilename, bool fProp = false, DubOptions *quick_opts=NULL);
void SaveAVI(char *szFilename, bool fProp = false, DubOptions *quick_opts=NULL, bool fCompatibility=false);
void SaveStripedAVI(char *szFile);
void SaveStripeMaster(char *szFile);
void SaveSegmentedAVI(char *szFilename, bool fProp, DubOptions *quick_opts, long lSpillThreshold, long lSpillFrameThreshold);
void SetSelectionStart(long ms);
void SetSelectionEnd(long ms);
void RemakePositionSlider();

#endif
