#ifndef f_DUBSOURCE_H
#define f_DUBSOURCE_H

#include <windows.h>
#include <vfw.h>

class InputFile;

class DubSource {
private:
	void *	format;
	int		format_len;

protected:
	void *allocFormat(int format_len);
	virtual BOOL _isKey(LONG lSample);

public:
	LONG lSampleFirst, lSampleLast;
	AVISTREAMINFO	streamInfo;

	DubSource();
	virtual ~DubSource();

	virtual BOOL init();
	int read(LONG lStart, LONG lCount, LPVOID lpBuffer, LONG cbBuffer, LONG *lBytesRead, LONG *lSamplesRead);
	virtual int _read(LONG lStart, LONG lCount, LPVOID lpBuffer, LONG cbBuffer, LONG *lBytesRead, LONG *lSamplesRead) = 0;

	void *getFormat() const { return format; }
	int getFormatLen() const { return format_len; }

	virtual bool isStreaming();

	BOOL isKey(LONG lSample);
	virtual LONG nearestKey(LONG lSample);
	virtual LONG prevKey(LONG lSample);
	virtual LONG nextKey(LONG lSample);

	virtual void streamBegin( bool fRealTime);
	virtual void streamEnd();

	LONG msToSamples(LONG lMs) const {
		return (LONG)(((__int64)lMs * streamInfo.dwRate + (__int64)500 * streamInfo.dwScale) / ((__int64)1000 * streamInfo.dwScale));
	}
	LONG samplesToMs(LONG lSamples) const {
		return (LONG)(
				(((__int64)lSamples * streamInfo.dwScale) * 1000 + streamInfo.dwRate/2) / streamInfo.dwRate
			);
	}

	// This is more accurate than AVIStreamSampleToSample(), which does a conversion to
	// milliseconds and back.

	static LONG samplesToSamples(const AVISTREAMINFO *dest, const AVISTREAMINFO *source, LONG lSamples) {
		__int64 divisor = (__int64)source->dwRate * dest->dwScale;

		return (LONG)((((__int64)lSamples * source->dwScale) * dest->dwRate + divisor/2)
				/ divisor);
	}

	LONG samplesToSamples(const DubSource *source, LONG lSamples) const {
		return samplesToSamples(&streamInfo, &source->streamInfo, lSamples);
	}
};

#endif