#include "filter.h"

#include "Effect.h"
#include "e_blur.h"

//#define USE_ASM

struct FilterBlurData {
	VEffect *effect;
};

static int blur_run(const FilterActivation *fa, const FilterFunctions *ff) {
	FilterBlurData *pfbd = (FilterBlurData *)fa->filter_data;

	if (pfbd->effect)
		pfbd->effect->run(&fa->dst);

	return 0;
}

static int blur_start(FilterActivation *fa, const FilterFunctions *ff) {
	FilterBlurData *pfbd = (FilterBlurData *)fa->filter_data;

	if (!(pfbd->effect = VCreateEffectBlur(&fa->dst)))
		return 1;

	return 0;
}

static long blur_param(FilterActivation *fa, const FilterFunctions *ff) {
	return 0;
}

static int blur_start2(FilterActivation *fa, const FilterFunctions *ff) {
	FilterBlurData *pfbd = (FilterBlurData *)fa->filter_data;

	if (!(pfbd->effect = VCreateEffectBlurHi(&fa->dst)))
		return 1;

	return 0;
}

static int blur_stop(FilterActivation *fa, const FilterFunctions *ff) {
	FilterBlurData *pfbd = (FilterBlurData *)fa->filter_data;

	delete pfbd->effect;
	pfbd->effect;

	return 0;
}


extern FilterDefinition filterDef_blur={
	0,0,NULL,
	"blur",
	"Applies a radius-1 gaussian blur to the image.",
	NULL,NULL,
	sizeof(FilterBlurData),
	NULL,NULL,
	blur_run,
	blur_param,
	NULL,
	NULL,
	blur_start,
	blur_stop
};

extern FilterDefinition filterDef_blurhi={
	0,0,NULL,
	"blur more",
	"Applies a radius-2 gaussian blur to the image.",
	NULL,NULL,
	sizeof(FilterBlurData),
	NULL,NULL,
	blur_run,
	blur_param,
	NULL,
	NULL,
	blur_start2,
	blur_stop
};
