///////////////////////////////////////////////////////////////////////////
//
//	For those of you who say this looks familiar... it should.  This is
//	the same linked-list style that the Amiga Exec uses, with dummy head
//	and tail nodes.  It's really a very convienent way to implement
//	doubly-linked lists.
//

#include "list.h"

List::List() {
	Init();
}

void List::Init() {
	head.next = tail.prev = 0;
	head.prev = &tail;
	tail.next = &head;
}

ListNode *List::RemoveHead() {
	if (head.prev->prev) {
		ListNode *t = head.prev;

		head.prev->Remove();
		return t;
	}

	return 0;
}

ListNode *List::RemoveTail() {
	if (tail.next->next) {
		ListNode *t = tail.next;

		tail.next->Remove();
		return t;
	}

	return 0;
}
