%{
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

static int thisline=0;
static int maxlen=31;
static int indent=3;
static int parbreaks=2;
static char *separator;

void usage();

%}
%%
[^\n\t\r
 ]+	{
	if ((thisline+strlen(yytext)) < maxlen) {
		printf("%s ",yytext); 
		thisline += strlen(yytext)+1;
	} else if ((thisline+strlen(yytext)) == maxlen) {
		printf("%s",yytext); 
		thisline += strlen(yytext);
	} else {
		printf("\n%s",yytext);
		thisline = strlen(yytext);
		if (thisline < maxlen) {
			thisline++;
			printf(" ");
		}
	};	
}
[\n][\t ]*[\n\r][\t \r\n]*	{
	printf(separator);
	thisline = indent;
}
[\n][\r\n\t ]*[\t ]+	{
	printf(separator);
	thisline = indent;
}
[\r][\t ]*[\r][\t \r]*	{
	printf(separator);
	thisline = indent;
}
[\r][\r\n\t ]*[\t ]+	{
	printf(separator);
	thisline = indent;
}
[ \r\n\t] ;

%%

int yywrap()
{
  return 1;
}

int main(int argc, char *argv[])
{
  int arg;
  int i;
  int fd,kid;
  int zpipe[2],lpipe[2];

  while ((arg=getopt(argc,argv,"n:i:c:")) != EOF) {
    switch (arg) {
      case 'n':
	parbreaks=atoi(optarg);
	break;
      case 'i':
	indent=atoi(optarg);
	break;
      case 'c':
	maxlen=atoi(optarg);
	break;
      default:
	usage();
	exit(0);
    }
  }
  
  putenv("LESSCHARSET=latin1");
  separator=malloc(parbreaks+indent+1);
  memset(separator,'\n',parbreaks);
  memset(separator+parbreaks,' ',indent);
  separator[indent+parbreaks]='\0';
  if (pipe(lpipe)) {
	  perror("lpipe");
	  exit(1);
  }
  if ((kid=fork()) > 0) {
	  close(lpipe[1]);	  
	  dup2(lpipe[0],0);	  
	  execlp("less",NULL);
	  perror("exec");
	  exit(3);
  } else if (kid < 0) {
	  perror("fork");
	  exit(3);
  } else {
	  close(lpipe[0]);	  
	  dup2(lpipe[1],1);	  
  }

  if ((argc-optind)>0) {
    for (i=optind; i<argc; i++) {
      if (strstr(argv[i],".gz")) {
        if (pipe(zpipe)) {
	  perror("pipe");
	  exit(1);
	}
	if (!(kid=fork())) {
	  close(0);	  
	  close(zpipe[0]);	  
	  dup2(zpipe[1],1);	  
	  execlp("zcat","zcat",argv[i],NULL);
	  perror("exec");
	  exit(3);
	} else if (kid < 0) {
	  perror("fork");
	  exit(3);
	} else {
	  close(zpipe[1]);	  
	  dup2(zpipe[0],0);	  
	}
      } else {
	if ((fd=open(argv[i],O_RDONLY)) < 0) {
	  perror(argv[i]);
	  exit(1);
        }
        if (dup2(fd,0) < 0) {
	  perror(argv[i]);
	  exit(1);
        }
      }
      printf("*** %s ***\n\n",argv[i]);
      yylex();
      printf("\n\nEOF %s\n\n",argv[i]);
    }
  } else {
    yylex();
  }
  exit(0);
}

void usage() {
  printf("reader, usage: reader [-i indent] [-n parbreaks] [-c cpl] [files]\n\n"
"defaults: -i %i -n %i -c %i\n\n",indent, parbreaks, maxlen);
}
