/**************************************************************************

	Example of IAviReadFile & IAviReadStream interface usage.
	Copyright 2000 Eugene Kuznetsov (divx@euro.ru)
	
**************************************************************************/


#include <avifile.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pthread.h>
#include <wine/vfw.h>
#include <aviplay.h>
#include <except.h>
#include <version.h>
#include <errno.h>
#include "audio.h"
#define __MODULE__ "decoder"

pid_t dec_pid;
char *outfile;

int main(int argc, char** argv)
{
    FILE* f=0;
    int fo,fokelz[2];
    IAviReadFile* ac=0;
    IAviReadStream* as=0;
    char* zz=0, *temp=0;
    IAudioRenderer* ar=0;
    audio_queue* aq=0;
    
    double tt=0.0,ft;
    if(GetAvifileVersion()!=AVIFILE_VERSION)
    {
	cout<<"This binary was compiled for Avifile ver. "<<AVIFILE_VERSION<<", but the library is ver. "<<GetAvifileVersion()<<". Aborting."<<endl;
	return 0;
    }	
    try
    {
        Unsigned samp_read, bytes_read;
//	f=fopen("./log2.mp3", "wb");
	if (argc<3) {
	  fprintf(stderr,"usage: %s infile.avi {outfile.raw|\"|encodingprogram\"}\n\nunfortunately libavifile currently produces too much debugging output to decode\nto stdout, force with /dev/stdout or specify a program to run with |\n",argv[0]);
	  exit(1);
	} else if (argv[2][0] == '|') {
	  if (pipe(fokelz)) {
	    perror("pipe");
	    exit(1);
	  }
	  if ((dec_pid=fork()) == 0) {
	    char *s=&argv[2][1];
	    close(0);
	    dup2(fokelz[0],0);
            close(fokelz[1]);
	    system(s);
            // close(fokelz[1]);
	    exit(errno);
	  } else if (dec_pid < 0) {
	    perror("fork");
	    exit(1);
	  }
	  fo=fokelz[1];
//	  close(fokelz[0]);
	} else {
	  fo=open(argv[2],O_RDWR|O_CREAT);
        }
	    
//	if(f==0)throw FATAL("Can't open ./log2.mp3 for writing");
	ac=CreateIAviReadFile(argv[1]);
        as=ac->GetStream(0, AviStream::Audio);
	ar=new File_AudioRenderer(as,fo);
	aq=new audio_queue();
        zz=new char[5000];
	temp=new char[5000000];
	ft=ar->buffer_time();
	printf("Audio Format: %s\n",ar->GetAudioFormat());

	ar->start();
	while (!as->Eof()) {
	    ar->doAudioExtract(ar->getTime());
	       
	}
    }
    catch(FatalError& error)
    {
	error.Print();
    }	
    if(f)fclose(f);
    if(ac)delete ac;
    if(zz)delete zz;	
}    
