#include <libio.h>
#include <stdio.h>
#include "st.h"

#define MY_BUFSIZE 50000

int main(int argc, char **argv)
{
	short *wordp, iword[MY_BUFSIZE],oword[MY_BUFSIZE];
	char *ip;
	int isamp=0,osamp=0;
	int irate, orate;
	unsigned long isum, osum;
	int i,start=0;
	
	irate=48000;
	orate=44100;

	if (argc>=2) {
		irate=atol(argv[1]);
		orate=atol(argv[2]);
	}

	resample_init(irate,orate);
	ip=(char *)iword;
	isum=osum=0;
	while ((isamp=read(0,ip,(irate>>4)<<2)/4)>0) {
		isum += isamp;
		fprintf(stderr,"read %i, ",isamp);
		osamp=resample_flow(ip, isamp, &oword);
		osum += osamp;
		write (1,oword,osamp*4);
		fprintf(stderr,"wrote %i\n",osamp);
	}
	if (isamp < 0) 
		perror("read samples");
		
	

	osamp=resample_stop(&oword);
	write (1,oword,osamp*4);
	fprintf(stderr,"drain: %i\n",osamp*4);
	osum += osamp;
	fprintf(stderr,"total: in %li, out %li\n",isum,osum);

}
