#include <math.h>
#include <string.h>


#include <stdio.h>
// #include <dlfcn.h>
#include <sys/types.h>
#include <dirent.h>
#include <gmodule.h>
#include <glib.h>

#include "config.h"
#ifdef TESTDL
#define GLOBAL_ /* used by global.h */

#endif
#include "global.h"

int dirsel(const struct dirent * de)
{
	if (strcmp(&de->d_name[0],".") && strcmp(&de->d_name[0],"..") &&
			strstr(&de->d_name[0],".so")) {
		return 1;
	};
	return 0;
}
#ifdef TESTDL
	
int main(int argc, char **argv)
{
	GModule **handle[100];
#else
int scan_codecs()
{
#endif
	GModule *hp;
	DIR *d;
	struct dirent **namelist;
	int n,i,j;
	gchar *lpath[100];
	struct interestingfunction *dummy;
	

	if (!g_module_supported()){
		perror("g_module_supported");
		exit(1);
	}
		
  	fprintf(stderr,"redirecting stdout to stderr\n");
	real_stdout=dup(1);
	close(1);
	fclose(stdout);
	/* if (dup2(2,1) != 1) {
		fprintf(stderr,"error redirecting stdout!\n");
	}*/
  	fprintf(stderr,"scanning codec dir %s: ",CODEC_DIR);

	n = scandir(CODEC_DIR,&namelist, dirsel, alphasort);
	if (n<0) {
		perror("scandir");
		exit(1);
	}
	for (i=0; i<n; i++) {
		lpath[0]=0;
		strncat((gchar *)&lpath,CODEC_DIR,99);
		strncat((gchar *)&lpath,"/",99); /* ok, stupid */
		strncat((gchar *)&lpath,namelist[i]->d_name,99);
//		g_return_val_if_fail (lpath != NULL, NULL);
		fprintf(stderr," %s",namelist[i]->d_name);
		codecs[i].handle=g_module_open((const gchar *)lpath,G_MODULE_BIND_LAZY);
		if (codecs[i].handle == NULL) {
			perror("g_module_open");
		} else {
			g_module_symbol(codecs[i].handle,"read_frame",(gpointer *)&(codecs[i].read_frame));
			g_module_symbol(codecs[i].handle,"check_file",(gpointer *)&(codecs[i].check_file));
			g_module_symbol(codecs[i].handle,"open_file",(gpointer *)&(codecs[i].open_file));
			g_module_symbol(codecs[i].handle,"close_file",(gpointer *)&(codecs[i].close_file));
			g_module_symbol(codecs[i].handle,"eof_file",(gpointer *)&(codecs[i].eof_file));
			g_module_symbol(codecs[i].handle,"get_video_width",(gpointer *)&(codecs[i].get_video_width));
			g_module_symbol(codecs[i].handle,"get_video_height",(gpointer *)&(codecs[i].get_video_height));
			g_module_symbol(codecs[i].handle,"get_video_framerate",(gpointer *)&(codecs[i].get_video_framerate));
			g_module_symbol(codecs[i].handle,"video_in",(gpointer *)&(codecs[i].video_in));
			if (codecs[i].video_in)
				fprintf(stderr,"(v)");
			g_module_symbol(codecs[i].handle,"audio_in",(gpointer *)&(codecs[i].audio_in));
			if (codecs[i].audio_in)
				fprintf(stderr,"(a)");
			g_module_symbol(codecs[i].handle,"muxer",(gpointer *)&(codecs[i].muxer));
			if (codecs[i].muxer)
				fprintf(stderr,"(v)");
#ifdef TESTDL
			fprintf(stderr,"%p %p %p %p %p %p %p %p %p %p %p: video %i\n",codecs[i].read_frame, codecs[i].check_file,codecs[i].open_file,codecs[i].close_file,codecs[i].eof_file,codecs[i].get_video_width,codecs[i].get_video_height,codecs[i].get_video_framerate,codecs[i].video_in,codecs[i].audio_in,codecs[i].muxer, (codecs[i].video_in)());
			fprintf(stderr,"read_frame check_file open_file close_file eof_file get_video_width get_video_height get_video_framerate video_in audio_in muxer\n");
#endif
			codecs[i].loaded=1;
		}
		free(namelist[i]);
	}
	fprintf(stderr,"\n");
	return(0);
}
