/*************************************************
*     rpld - an IBM style RIPL server            *
*************************************************/

/* Copyright (c) 1999,2000, James McKenzie.
 *                      All rights reserved
 * Copyright (c) 1998,2000, Christopher Lightfoot.
 *                      All rights reserved
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENCE file which can be found at the top level of
 * the rpld distribution.
 *
 * IBM is a trademark of IBM corp.
 *
 */


static char rcsid[] =
  "$Id: rpld.c,v 1.18 2000/07/23 19:14:19 root Exp root $";

/*
 * $Log: rpld.c,v $
 * Revision 1.18  2000/07/23 19:14:19  root
 * #
 *
 * Revision 1.17  2000/07/17 11:59:45  root
 * #
 *
 * Revision 1.16  2000/07/17 10:49:20  root
 * #
 *
 * Revision 1.15  2000/07/17 10:45:38  root
 * #
 *
 * Revision 1.14  2000/07/17 10:43:54  root
 * #
 *
 * Revision 1.13  2000/07/17 10:43:34  root
 * #
 *
 * Revision 1.12  2000/07/16 14:22:06  root
 * #
 *
 * Revision 1.11  2000/07/16 14:05:28  root
 * #
 *
 * Revision 1.10  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.9  1999/09/13 11:17:35  root
 * \#
 *
 * Revision 1.8  1999/09/13 11:05:27  root
 * \#
 *
 * Revision 1.7  1999/09/13 11:04:13  root
 * \#
 *
 */

#include "project.h"

static unsigned char RPL_MC_ADDR[ETH_ALEN] = { 0x3, 0x0, 0x2, 0x0, 0x0, 0x0 };

int downloading = 0;
int pacing = 10000;

int
main (argc, argv)
     int argc;
     char **argv;
{
  unsigned char buf[MAX_FRAME_LEN];
  struct llchdr *h = (struct llchdr *) buf;
  struct timeval last;

  struct nit *n;

  openlog ("rpld", LOG_PID, LOG_DAEMON);

  parse_config ();

  daemonize ();

  n = nit_open (NULL);

  if (!n)
    {
      syslog (LOG_ERR, "failed to initalize nit");
      return (-1);
    }

  nit_multicast (n, RPL_MC_ADDR);

  syslog (LOG_ERR, "my hw addr = %s", ethtoa (nit_mac (n)));


  gettimeofday (&last, NULL);


  while (1)
    {
      int len;
      struct timeval tv;


      if (downloading)
        {
          tv.tv_sec = 0;
          tv.tv_usec = pacing >> 1;
        }
      else
        {
          tv.tv_sec = 10;
          tv.tv_usec = 0;
        }

      len = nit_read_packet (n, buf, sizeof (buf), &tv);


      if ((len > LLC_HDR_LEN) && (ntohs (h->h_len) <= 1514))
        {                       /*Short circuit most packets */
          llc_recv_packet (n, buf, len);
        }


      if (downloading)
        {
          gettimeofday (&tv, NULL);

          len = tv.tv_sec;
          len -= last.tv_sec;
          if (len > 1)
            len = 2;
          len *= 1000000;
          len += tv.tv_usec;
          len -= last.tv_usec;



          if (len > pacing)
            {
              client_dispatch (n);
              gettimeofday (&last, NULL);

            }
        }
    }

  nit_close (n);

  return 0;
}
