%token EXTERN FUNC END IF THEN ELSEIF ELSE 
%token BOPEN BCLOSE PLUS MINUS MULT LESS SEMI EQUAL 
%token INT IDENT 

%start start

%{
#include "list.h"
#include "oxout.h"
%}

@traversal @lefttoright LTR

@attributes {char *text;} INT P_INT IDENT P_IDENT X_IDENT
@autoinh loclist 
@autoinh globlist
@attributes {slist *loclist; slist *globlist;} 
	functext function expr elsifthenexpr multerm plusminusterm term
@attributes {slist *glist;} program 
@attributes {char *text; slist *globlist;} decl
%%

start		: program
		@{ @i @program.glist@=(slist*) NULL; @}
		;

program	        : 
                | decl P_SEMI program
		@{ 
                   @i @program.1.glist@ = 
			insert(@decl.text@,@program.glist@,1);
		   @i @decl.globlist@ = @program.1.glist@;
		@}
		;

decl		: P_IDENT P_EQUAL functext 
                @{ 
		   @i @functext.loclist@ = (slist*)NULL;
		   @i @decl.text@ = @P_IDENT.text@; 
		@}
		;

functext	: function
		| P_EXTERN
		;

expr		: function
		| P_IF expr P_THEN expr elsifthenexpr P_ELSE expr P_END P_IF
                | expr P_BOPEN expr P_BCLOSE
		| P_MINUS term plusminusterm 
		| term plusminusterm 
		| term multerm
		| term P_LESS term
		;

function	: P_FUNC P_BOPEN P_IDENT P_BCLOSE expr P_END P_FUNC
		@{ 
		   @i @expr.loclist@ = 
			insert(@P_IDENT.text@,@function.loclist@,0);
		@}
		;
		
elsifthenexpr	: 
                | P_ELSEIF expr P_THEN expr elsifthenexpr
		;

plusminus	: P_PLUS 
		| P_MINUS
		;

plusminusterm	: 
                | plusminus term plusminusterm
		;

multerm		: P_MULT term
                | P_MULT term multerm
		;


term		: P_BOPEN expr P_BCLOSE
		| X_IDENT
                @{ @LTR printf("%s",getNodeString(@X_IDENT.text@,
			  @term.loclist@,@term.globlist@)); 
		@}
		| P_INT
		;

P_EXTERN	: EXTERN 	@{ @LTR printf("extern "); @};
P_FUNC		: FUNC 		@{ @LTR printf("func "); @};
P_END		: END		@{ @LTR printf("end "); @};
P_IF		: IF 		@{ @LTR printf("if "); @};
P_THEN		: THEN 		@{ @LTR printf("then "); @};
P_ELSEIF	: ELSEIF 	@{ @LTR printf("elseif "); @};
P_ELSE		: ELSE 		@{ @LTR printf("else "); @};
P_EQUAL		: EQUAL		@{ @LTR printf("= "); @};
P_LESS		: LESS		@{ @LTR printf("< "); @};
P_SEMI		: SEMI		@{ @LTR printf("; "); @};
P_BOPEN		: BOPEN		@{ @LTR printf("( "); @};
P_BCLOSE	: BCLOSE	@{ @LTR printf(") "); @};
P_PLUS		: PLUS 		@{ @LTR printf("+ "); @};
P_MINUS		: MINUS		@{ @LTR printf("- "); @};
P_MULT		: MULT 		@{ @LTR printf("* "); @};
P_INT		: INT 
		@{
		  @LTR printf("%s ",@INT.text@);
		  @i @P_INT.text@=@INT.text@;
		@}
X_IDENT		: IDENT
		@{ 
		  @i @X_IDENT.text@=@IDENT.text@;
		@}

P_IDENT		: IDENT 
		@{ 
		  @LTR printf("%s ",@IDENT.text@);
		  @i @P_IDENT.text@=@IDENT.text@;
		@}
		
%%

#include <stdio.h>

int yyerror()
{
  fprintf(stderr,"parse error\n");
  exit(1);
}

int main(int argc, char *argv[])
{
  if(yyparse() == 1) {
    fprintf(stderr, "parse error\n");
    exit(1);
  }
  exit(0);
}
