module Aufgabe3 where

-- isPrime: einfache variante (2, ... teilbar)

-- testfunktion: gibt neben true/false noch ersten teiler an
-- bruteforce-test

isPrimeVerb :: Integer -> (Bool, Integer)
isPrimeVerb n
  | n<2 = (False,1)
  | n==2 = (True,0)
  | rem n 2 == 0  = (False,2)
  | otherwise = isPrime' n 3 where
  isPrime' :: Integer -> Integer -> (Bool,Integer)
  isPrime' n i 
    | i*i > n = (True,0)
    | rem n i == 0  = (False,i)
    | otherwise = isPrime' n (i+2)

-- eigentliche funktion

isPrime :: Integer -> Bool
isPrime n = first (isPrimeVerb n) where
  first (x,y) = x

-- ruft wiederholt isPrime auf

listPrime :: Integer -> Integer -> [Integer]
listPrime l r 
  | r < l = error "negative interval"
  | otherwise = [ b | b <- [l..r], isPrime b ]

-- sick, slow, heavyweight, sucks. should get full marks.
-- memo to self etc: liste der paare, fuer die gilt, 
--                   dass y^z fuer max z n teilt 
-- (ohne abbruchbedingung, rechnet daher fuer grosse zahlen geometrisch laenger)

primFaktorZerlegung_boese :: Integer -> [(Integer,Integer)]
primFaktorZerlegung_boese n = [ (y,z) | y <- listPrime 1 (div (n+1) 2), rem n y == 0, z <- [maximum [ i | i <- takeWhile (\a -> (rem n (y^a)) == 0) [1..n]]] ]

-- ok: factors remainder recursively, termination more likely than above

primFaktorZerlegung1 :: Integer -> [(Integer,Integer)]
primFaktorZerlegung1 n = primFaktorZerlegung' n 2 [] where
  primFaktorZerlegung' a b factors
    | a == 1 = factors
    | rem a b == 0 = primFaktorZerlegung' (div a (b^(maxf a b))) (if b==2 then 3 else b+2) (concat [ factors,[(b,maxf a b)]])
    | otherwise = primFaktorZerlegung' a (if b==2 then 3 else b+2) factors 

primFaktorZerlegung :: Integer -> [(Integer,Integer)]
primFaktorZerlegung n = head (filter (\l -> (expose l) == n) (map (\l -> take l [ (y,z) | y <- listPrime 2 n, rem n y == 0, z <- [maximum [ i | i <- takeWhile (\a -> (rem n (y^a)) == 0) [1..n]]] ]) [1..])) where
  expose ((a,b):ls) = (if ls == [] then (a^b) else (a^b)*(expose ls))


-- hilfsfunktion: auch unten benoetigt
-- maxf a1 b1 = last (takeWhile (\i -> (rem a1 (b1^i)) == 0) [1..a1]) 

-- kgv

-- wie oben: implementation ohne abbruch -> 
--   fuer nicht-primzahlen hoeherer aufwand

kgv_bad :: Integer -> Integer -> Integer
kgv_bad a b = merge a b where
  merge :: Integer -> Integer -> Integer 
  merge a b = product [ y^z | y <- listPrime 1 (max a b), rem a y == 0 || rem b y == 0, z <- [maximum [ i | i <- takeWhile (\interim -> (rem a (y^interim)) == 0 || (rem b (y^interim)) == 0) [1..(max a b)]]] ]


kgv :: Integer -> Integer -> Integer
kgv a b = merge a b 2 1 where
  merge a1 a2 b1 product1
    | ((a1 == 1) && (a2 == 1)) = product1
    | ((rem a1 b1 == 0) || (rem a2 b1 == 0)) = merge (div a1 (b1^(maxf a1 b1))) (div a2 (b1^(maxf a2 b1))) (if b1==2 then 3 else b1+2) (product1*(b1^(max (maxf a1 b1) (maxf a2 b1))))
    | otherwise = merge a1 a2 (if b1==2 then 3 else b1+2) product1 

maxf aa1 bb1 = last (takeWhile (\i -> (rem aa1 (bb1^i)) == 0) [0..aa1]) 

kgv1 :: Integer -> Integer -> Integer
kgv1 a b = product [ y^z | y <- listPrime 1 (max a b), rem a y == 0 || rem b y == 0, z <- [maximum [ i | i <- takeWhile (\interim -> (rem a (y^interim)) == 0 || (rem b (y^interim)) == 0) [1..(max a b)]]] ]

